# 📱 Configuration Widget iOS & Apple Watch

## Vue d'ensemble

Ce guide explique comment ajouter le Widget iOS et l'application Apple Watch à votre projet Personnel Assistant.

---

## 🎯 Widget iOS (WidgetKit)

### Étape 1: Ajouter la Target Widget

1. Dans Xcode, cliquez sur **File → New → Target**
2. Sélectionnez **Widget Extension**
3. Nommez-la: `PersonnelAssistantWidget`
4. Bundle Identifier: `com.codincloud.personnelassistant.widget`
5. **Décochez** "Include Configuration Intent" (on utilise App Intents)
6. Cliquez **Finish**

### Étape 2: Remplacer le contenu

Supprimez les fichiers générés par défaut et copiez le contenu de:
- `PersonnelAssistantWidget/PersonnelAssistantWidget.swift`
- `PersonnelAssistantWidget/Info.plist`

### Étape 3: Configurer le App Group

1. Sélectionnez la target Widget
2. Allez dans **Signing & Capabilities**
3. Ajoutez **App Groups**
4. Créez: `group.com.codincloud.personnelassistant`
5. Faites de même pour la target principale

---

## ⌚ Apple Watch App

### Étape 1: Ajouter la Target Watch

1. Dans Xcode, cliquez sur **File → New → Target**
2. Sélectionnez **watchOS → App**
3. Nommez-la: `PersonnelAssistantWatch`
4. Bundle Identifier: `com.codincloud.personnelassistant.watchkitapp`
5. Watch App Type: **App for existing iOS app**
6. Cliquez **Finish**

### Étape 2: Remplacer le contenu

Copiez les fichiers de `PersonnelAssistantWatch/`:
- `PersonnelAssistantWatchApp.swift`
- `Complications.swift`
- `Info.plist`

### Étape 3: Ajouter Watch Connectivity à l'app iOS

La target principale doit avoir le framework `WatchConnectivity` ajouté.

---

## 🗣️ Siri Shortcuts (App Intents)

### Étape 1: Ajouter les Intents à l'app principale

1. Ajoutez `Intents/AssistantIntents.swift` à la target principale
2. Les raccourcis Siri seront automatiquement disponibles

### Étape 2: Activer les phrases "dmagh"

Une fois l'app installée:
1. Allez dans **Réglages → Siri & Recherche**
2. Trouvez **Personnel Assistant**
3. Les phrases "dmagh" seront suggérées

---

## 📋 Checklist

### Widget iOS
- [ ] Target Widget créée
- [ ] PersonnelAssistantWidget.swift ajouté
- [ ] App Groups configuré
- [ ] Tester sur simulateur

### Apple Watch
- [ ] Target Watch créée
- [ ] PersonnelAssistantWatchApp.swift ajouté
- [ ] Complications.swift ajouté
- [ ] WatchConnectivity activé
- [ ] Tester sur simulateur Watch

### Siri
- [ ] AssistantIntents.swift ajouté à la target principale
- [ ] Tester "Hey Siri, dmagh"

---

## 🎨 Widgets disponibles

| Taille | Description |
|--------|-------------|
| Small | Logo + "dmagh" + statut |
| Medium | Actions rapides (Vocal, Chat, Infra) |
| Large | Dashboard complet avec statuts |
| Lock Screen (Circular) | Icône dmagh |
| Lock Screen (Rectangular) | Nom + statut |

---

## ⌚ Complications Watch

| Type | Description |
|------|-------------|
| Circular | Icône brain + "dmagh" |
| Rectangular | Logo + nom + statut services |
| Inline | "dmagh • En ligne" |
| Corner | Icône avec label |

---

## 🔗 Deep Links

L'app supporte les URLs suivantes:

```
personnelassistant://voice        → Ouvre mode vocal
personnelassistant://chat         → Ouvre chat
personnelassistant://infrastructure → Ouvre infrastructure
personnelassistant://tools        → Ouvre outils
personnelassistant://settings     → Ouvre paramètres
```

Ces liens sont utilisés par le Widget et l'Apple Watch.

---

## 🎤 Activation vocale "dmagh"

Dites à Siri:
- "dmagh"
- "Hey dmagh"
- "OK dmagh"
- "Ouvre dmagh"
- "dmagh écoute"

L'assistant s'ouvrira automatiquement en mode écoute!
